#pragma once

#include "Vector.h"

#include <QtOpenGL/QGLWidget>

inline void glVertex(const Vector& V)
{
	glVertex3d(V.X, V.Y, V.Z);
}

inline void glNormal(const Vector& V)
{
	glNormal3d(V.X, V.Y, V.Z);
}

inline void glQuad(const Vector& A, const Vector& B, const Vector& C, const Vector& D)
{
	glNormal((C-B)^(A-B));
	glVertex(A);
	glVertex(B);
	glVertex(C);
	glVertex(D);
}

inline void glTriangle(const Vector& A, const Vector& B, const Vector& C)
{
	glNormal((C-B)^(A-B));
	glVertex(A);
	glVertex(B);
	glVertex(C);
}

class LongBlock
{
public:
	LongBlock();
	
	void Build(double alpha);
	void Render();
	void RenderHinges();
	
	LongBlock Reflected(const Vector& Offset, const Vector& Normal);
	
	Vector Centre();
	
private:
	// Middle end. Anticlockwise from bottom left (rotated by alpha).
	
	Vector A;
	Vector B;
	Vector C;
	Vector D;
	
	// Other end. Same order looking from the same end.
	
	Vector a;
	Vector b;
	Vector c;
	Vector d;
};

class ShortBlock
{
public:
	ShortBlock();
	
	void Build(double alpha, double beta, double psi);
	
	Vector GetPlaneOffset();
	Vector GetPlaneNormal();
	
	void Render();
	void RenderHinges();
	
	ShortBlock Reflected(const Vector& Offset, const Vector& Normal);
	
private:
	// Bent corner end.
	Vector e;
	Vector f;
	Vector g;
	Vector h;
	
	// Middle twist.
	
	Vector et;
	Vector ft;
	Vector gt;
	Vector ht;
	Vector Et;
	Vector Ft;
	Vector Gt;
	Vector Ht;
	
	int rotation;
	
	// Flat end.
	Vector E;
	Vector F;
	Vector G;
	Vector H;
};
