#pragma once

#include <QtOpenGL/QGLWidget>

#include "Block.h"

class ViewWidget : public QGLWidget
{
	Q_OBJECT
public:
	ViewWidget(QWidget* parent = 0);
	~ViewWidget();
	
	QSize minimumSizeHint() const;
	QSize sizeHint() const;
public slots:
	void setAlpha(int angle);
	void setBeta(int angle);
	void setPsi(int angle);
protected:
	void initializeGL();
	void paintGL();
	void resizeGL(int width, int height);
	void mousePressEvent(QMouseEvent *event);
	void mouseMoveEvent(QMouseEvent *event);
	void wheelEvent(QWheelEvent* event);

private:
	int alpha;
	int beta;
	int psi;
	QPoint lastPos;
	
	// Viewing angle.
	int viewTheta;
	int viewPhi;
	int viewZoom;
	
	ShortBlock shortBlock;
	LongBlock longBlock;
};
