#include "Graphics.h"
#include "ViewWidget.h"
#include "Maths.h"

#include <QMouseEvent>
#include <QDebug>
#include <QPainter>
#include <QPainterPath>

ViewWidget::ViewWidget(QWidget* parent) : QWidget(parent)
{
	alpha1 = 0.0;
	alpha2 = 0.0;
	gamma = 0.0;
}


ViewWidget::~ViewWidget()
{
}

void ViewWidget::setAlpha1(double angle)
{
	alpha1 = angle;
	update();
}

void ViewWidget::setAlpha2(double angle)
{
	alpha2 = angle;
	update();
}
void ViewWidget::setGamma(double angle)
{
	gamma = angle;
	update();
}

void ViewWidget::paintEvent(QPaintEvent* e)
{
	QPainterPath path1;
	path1.moveTo(0, 0);
	
	double lastValue = -INFINITY;

	for (double psi = 0.001; psi <= Pi2; psi += Pi2/300.0)
	{
		Block1 block1;
		Block2 block2;
		Block3 block3;
		
		block1.Build(alpha1, 2.0 * alpha1 - gamma, alpha2, 2.0 * alpha2 - gamma);
		block2.Build(alpha1, alpha2);
		block3.Build(alpha1, 2.0 * alpha1 - gamma, alpha2, 2.0 * alpha2 - gamma);
	
		block3.Open(psi);
	
		// Calculate the two psi12 values.
	
		// Make the maths not pathlogocial.
	
		// TODO: If F or f == 0 (or less than some small value), then special case.
		pair<double, double> psi12s =
			RotationsForPlane(block3.GetSymmetryHingeOffset(), block3.GetSymmetryHingeDirection(),
							block1.GetSymmetryHingeOffset(), block1.GetSymmetryHingeDirection(),
							block1.GetFoldingHingeOffset(), block1.GetFoldingHingeDirection());
		
		double sln = psi12s.first;
		if (sln < 1000.0 && sln > -1000.0)
		{
			block1.Open(sln);
		}


		double error = abs((block1.GetSymmetryHingeDirection() ^ (block3.GetSymmetryHingeOffset() - block1.GetSymmetryHingeOffset()))
	                   * (block3.GetSymmetryHingeOffset() + block3.GetSymmetryHingeDirection() - block1.GetSymmetryHingeOffset()));
		
		if (error < 0.001)
		{
			if (lastValue == -INFINITY || (lastValue > Pi3_2 && sln < Pi_2) || (lastValue < Pi_2 && sln > Pi3_2))
				path1.moveTo(psi / Pi2 * width(), (1.0 - (sln / Pi2)) * height());
			else
				path1.lineTo(psi / Pi2 * width(), (1.0 - (sln / Pi2)) * height());
			
			lastValue = sln;				
		}
		else
		{	
			lastValue = -INFINITY;
		}
	}

	QPainterPath path2;
	
	QPainterPath path2svd;

	lastValue = -INFINITY;
	bool secondWorks = true;
	
	for (double psi = 0.001; psi <= Pi2; psi += Pi2/300.0)
	{
		Block1 block1;
		Block2 block2;
		Block3 block3;
		
		block1.Build(alpha1, 2.0 * alpha1 - gamma, alpha2, 2.0 * alpha2 - gamma);
		block2.Build(alpha1, alpha2);
		block3.Build(alpha1, 2.0 * alpha1 - gamma, alpha2, 2.0 * alpha2 - gamma);
	
		block3.Open(psi);
	
		// Calculate the two psi12 values.
	
		// Make the maths not pathlogocial.
		// TODO: If F or f == 0 (or less than some small value), then special case.
		pair<double, double> psi12s =
			RotationsForPlane(block3.GetSymmetryHingeOffset(), block3.GetSymmetryHingeDirection(),
							block1.GetSymmetryHingeOffset(), block1.GetSymmetryHingeDirection(),
							block1.GetFoldingHingeOffset(), block1.GetFoldingHingeDirection());
		
		double sln = psi12s.second;
		
		// Avoid crazy solutions.
		if (sln < 1000.0 && sln > -1000.0)
		{
			//			secondWorks = false;
			block1.Open(sln);
		}
		
		if ((sln < 0.0 || sln > PsiMax(alpha1)) && psi < PsiMax(alpha2))
			secondWorks = false;
		
		if (psi == 0.001 && abs(sln) > PsiMax(alpha1) / 10.0 && psi < PsiMax(alpha2))
			secondWorks = false;
		
		if (psi > PsiMax(alpha2) - Pi2/300.0 && psi < PsiMax(alpha2) && abs(sln - PsiMax(alpha1)) > PsiMax(alpha1) / 10.0)
			secondWorks = false;

		double error = abs((block1.GetSymmetryHingeDirection() ^ (block3.GetSymmetryHingeOffset() - block1.GetSymmetryHingeOffset()))
	                   * (block3.GetSymmetryHingeOffset() + block3.GetSymmetryHingeDirection() - block1.GetSymmetryHingeOffset()));
		
		if (error < 0.001)
		{
			vector<double> svs = GetSVD(block1, block3);
			
			qDebug() << svs[4];

			
			if (lastValue == -INFINITY || (lastValue > Pi3_2 && sln < Pi_2) || (lastValue < Pi_2 && sln > Pi3_2))
			{
				path2.moveTo(psi / Pi2 * width(), (1.0 - (sln / Pi2)) * height());
				path2svd.moveTo(psi / Pi2 * width(), (1.0 - (log(svs[4]) + 3.0)/4.0) * height());
			}
			else
			{
				path2.lineTo(psi / Pi2 * width(), (1.0 - (sln / Pi2)) * height());
				path2svd.lineTo(psi / Pi2 * width(), (1.0 - (log(svs[4]) + 3.0)/4.0) * height());
			}			
			
			lastValue = sln;
		}
		else
		{
			if (psi < PsiMax(alpha2))
				secondWorks = false;
			lastValue = -INFINITY;
		}
	}
	QPainter painter(this);
	
	painter.fillRect(e->rect(), Qt::white);
	
	painter.setBrush(Qt::NoBrush);
	painter.setPen(Qt::red);
	painter.drawPath(path1);
	painter.setPen(Qt::blue);
	painter.drawPath(path2);
	painter.setPen(Qt::black);
	painter.drawPath(path2svd);
	
	painter.setPen(Qt::red);
	if (secondWorks)
		painter.setPen(Qt::green);
	painter.drawLine(0, (1.0 - (PsiMax(alpha1) / Pi2)) * height(),
	                 width(), (1.0 - (PsiMax(alpha1) / Pi2)) * height());
	painter.drawLine(width() * PsiMax(alpha2) / Pi2, 0.0,
	                 width() * PsiMax(alpha2) / Pi2, height());
}

