#pragma once

#include "Vector.h"

#include <QtOpenGL/QGLWidget>

class Block2
{
public:
	Block2();
	
	void Build(double alpha1, double alpha2);
	
	void Render() const;
	void RenderHinges() const;
	
	Block2 Reflected(const Vector& Offset, const Vector& Normal) const;
	
	Vector Centre() const;
	
private:
	// 12 end
	
	Vector A;
	Vector B;
	Vector C;
	Vector D;
	
	// 23 end
	
	Vector a;
	Vector b;
	Vector c;
	Vector d;

	// Middle twist - the ends projected onto a plane and offset a bit.

	Vector At;
	Vector Bt;
	Vector Ct;
	Vector Dt;

	Vector at;
	Vector bt;
	Vector ct;
	Vector dt;

	int rotation; // Ugly hack for the twist.
};

class Block1
{
public:
	Block1();

	void Build(double alpha1, double beta1, double alpha2, double beta2);

	void Open(double psi12);
	
	void Render() const;
	void RenderHinges() const;

	Vector GetSymmetryHingeOffset() const;
	Vector GetSymmetryHingeDirection() const;

	Vector GetFoldingHingeOffset() const;
	Vector GetFoldingHingeDirection() const;
	
	Block1 Reflected(const Vector& Offset, const Vector& Normal) const;
	
private:

	// Bent corner end.
	Vector e;
	Vector f;
	Vector g;
	Vector h;
	
	// Middle twist.
	
	Vector et;
	Vector ft;
	Vector gt;
	Vector ht;
	Vector Et;
	Vector Ft;
	Vector Gt;
	Vector Ht;
	
	// Flat end.
	Vector E;
	Vector F;
	Vector G;
	Vector H;
	
	int rotation; // Ugly hack for the twist.
};


class Block3
{
public:
	Block3();
	
	void Build(double alpha1, double beta1, double alpha2, double beta2);
	
	void Open(double psi23);
	
	void Render() const;
	void RenderHinges() const;
	
	Vector GetSymmetryHingeOffset() const;
	Vector GetSymmetryHingeDirection() const;

	Vector GetFoldingHingeOffset() const;
	Vector GetFoldingHingeDirection() const;
	
	Block3 Reflected(const Vector& Offset, const Vector& Normal) const;
	
private:
	// Bent corner end.
	Vector e;
	Vector f;
	Vector g;
	Vector h;
	
	// Middle twist.
	
	Vector et;
	Vector ft;
	Vector gt;
	Vector ht;
	Vector Et;
	Vector Ft;
	Vector Gt;
	Vector Ht;
	
	// Flat end.
	Vector E;
	Vector F;
	Vector G;
	Vector H;
	
	int rotation; // Ugly hack for the twist.
};

inline int RotationFromAngleOffset(double off)
{
	while (off < 0.0)
		off += Pi2;
	while (off >= Pi2)
		off -= Pi2;
	if (off < Pi_2)
		return 0;
	else if (off < Pi)
		return 1;
	else if (off < Pi3_2)
		return 2;

	return 3;
}

inline double PsiMax(double alpha)
{
	if (alpha > 0.0)
		return Pi - acos(pow(cos(alpha),2));
	return Pi + acos(pow(cos(alpha),2));
}
