#pragma once

#include <QtOpenGL>
#include "Vector.h"

// Some useful graphics functions.

inline void glVertex(const Vector& V)
{
	glVertex3d(V.X, V.Y, V.Z);
}

inline void glNormal(const Vector& V)
{
	glNormal3d(V.X, V.Y, V.Z);
}

inline void glQuad(const Vector& A, const Vector& B, const Vector& C, const Vector& D)
{
	glNormal((C-B)^(A-B));
	glVertex(A);
	glVertex(B);
	glVertex(C);
	glVertex(D);
}

inline void glTriangle(const Vector& A, const Vector& B, const Vector& C)
{
	glNormal((C-B)^(A-B));
	glVertex(A);
	glVertex(B);
	glVertex(C);
}

