#pragma once

#include <QtOpenGL>

#include "Block.h"

class ViewWidget : public QGLWidget
{
	Q_OBJECT
public:
	ViewWidget(QWidget* parent = 0);
	~ViewWidget();
	
	QSize minimumSizeHint() const;
	QSize sizeHint() const;

public slots:
	void setAlpha1(double angle);
	void setAlpha2(double angle);
	void setGamma(double angle);
	void setPsi(double angle);
	
protected:
	void initializeGL();
	void paintGL();
	void resizeGL(int width, int height);
	void mousePressEvent(QMouseEvent *event);
	void mouseMoveEvent(QMouseEvent *event);

private:
	double alpha1;
	double alpha2;
	double gamma;
	double psi;
	QPoint lastPos;
	
	// Viewing angle.
	double viewTheta;
	double viewPhi;
	// Viewing centre.
	Vector viewCentre;
	// Camera distance from the centre.
	double viewDistance; 
	
	// The blocks.
	Block1 block1;
	Block2 block2;
	Block3 block3;

	// Reconstruct the block positions each time a slider is moved.
	void reBuildBlocks();

	bool whichSolution;
};
