#include "MainWindow.h"

void normalise(double& angle)
{
	while (angle >= Pi)
		angle -= 2.0 * Pi;
	while (angle < -Pi)
		angle += 2.0 * Pi;
}

MainWindow::MainWindow(QWidget* parent) : QDialog(parent)
{
	setupUi(this);

	// Private connections.
	connect(alpha1Slider, SIGNAL(valueChanged(int)), this, SLOT(_alpha1Changed(int)));
	connect(alpha2Slider, SIGNAL(valueChanged(int)), this, SLOT(_alpha2Changed(int)));
	connect(gammaSlider, SIGNAL(valueChanged(int)), this, SLOT(_gammaChanged(int)));

	// Connections with the view widget.
	connect(this, SIGNAL(alpha1Changed(double)), viewWidget, SLOT(setAlpha1(double)));
	connect(this, SIGNAL(alpha2Changed(double)), viewWidget, SLOT(setAlpha2(double)));
	connect(this, SIGNAL(gammaChanged(double)), viewWidget, SLOT(setGamma(double)));
}

void MainWindow::_alpha1Changed(int angle)
{
	double a = (2.0 * angle - alpha1Slider->minimum() - alpha1Slider->maximum()) * Pi / (alpha1Slider->maximum() - alpha1Slider->minimum());
	alpha1Label->setText(QString::number(a/Pi) + " " + QChar(0x03C0));
	emit alpha1Changed(a);
}
void MainWindow::_alpha2Changed(int angle)
{
	double a = (2.0 * angle - alpha2Slider->minimum() - alpha2Slider->maximum()) * Pi / (alpha2Slider->maximum() - alpha2Slider->minimum());
	alpha2Label->setText(QString::number(a/Pi) + " " + QChar(0x03C0));
	emit alpha2Changed(a);
}
void MainWindow::_gammaChanged(int angle)
{
	double a = (2.0 * angle - gammaSlider->minimum() - gammaSlider->maximum()) * Pi / (gammaSlider->maximum() - gammaSlider->minimum());
	gammaLabel->setText(QString::number(a/Pi) + " " + QChar(0x03C0));
	emit gammaChanged(a);
}

