#include "Maths.h"

#include "Graphics.h"

#include <QDebug>

#include <iostream>

using namespace std;

// Ok this is a bit silly.
pair<double, double> RotationsForPlaneHack(const Vector& fixed_point, const Vector& fixed_direction,
                                       const Vector& rotating_point, const Vector& rotating_direction,
                                           const Vector& axis);

pair<double, double> RotationsForPlane(Vector x, Vector a, Vector y, Vector b, Vector g, Vector h)
{
	a.Normalise();
	b.Normalise();
	h.Normalise();

	return RotationsForPlaneHack(x - g, a, y - g, b, h);
}


// Returns 0 <= x <= 2 Pi
double angleOf(double x, double y)
{
	double len = sqrt(x*x + y*y);
	if (len == 0.0)
		return 0.0;
	x /= len;
	y /= len;
	if (y == 0.0)
	{
		if (x < 0.0)
			return Pi3_2;
		else
			return Pi_2;
	}
	else if (x == 0.0)
	{
		if (y < 0.0)
			return Pi;
		else
			return 0.0;
	}
	else
	{
		double r = atan(x/y);
		if (y < 0.0)
			r += Pi;
		return r;
	}
	return 0.0;
}

double angleFrom(double x1, double y1, double x2, double y2)
{
	double r = angleOf(x2, y2) - angleOf(x1, y1);
	while (r >= Pi2)
		r -= Pi2;
	while (r <= 0.0)
		r += Pi2;
	return r;
}

pair<double, double> RotationsForPlaneHack(const Vector& fixed_point, const Vector& fixed_direction,
                                       const Vector& rotating_point, const Vector& rotating_direction,
                                       const Vector& axis)
{
	// To make this simple, we will rotate the whole thing so that the axis is just the z axis.
	// Presumably the maths could be worked out but this is more simple.

	// Work out the axis that we must rotate everything about to get /axis/ as the z axis.

	Vector rotateAllAxis = axis.Normalised() ^ ZZ;

	// The angle.
	
	double angle = asin(rotateAllAxis * rotateAllAxis.Normalised());
	if (axis.Z < 0)
		angle = Pi - angle;
	
	rotateAllAxis = rotateAllAxis.Normalised() * angle;

	// Now rotate everything like that.

	Vector fixed_point_ = Rotate(fixed_point, Vector(), rotateAllAxis);
	Vector fixed_direction_ = Rotate(fixed_direction.Normalised(), Vector(), rotateAllAxis);
	Vector rotating_point_ = Rotate(rotating_point, Vector(), rotateAllAxis);
	Vector rotating_direction_ = Rotate(rotating_direction.Normalised(), Vector(), rotateAllAxis);

	// There, now axis is just ZZ.

	// Now we need to find the two points on both lines when x^2 + y^2 is the same. This is given by z1, z2 = :

	double a = fixed_point_.X;
	double b = fixed_point_.Y;
	double c = fixed_point_.Z;

	double e = fixed_direction_.X;
	double f = fixed_direction_.Y;
	double g = fixed_direction_.Z;
	
	double A = rotating_point_.X;
	double B = rotating_point_.Y;
	double C = rotating_point_.Z;

	double E = rotating_direction_.X;
	double F = rotating_direction_.Y;
	double G = rotating_direction_.Z;

	if (e == E && f == F && g == G)
	{
		return pair<double, double>(0.0, Pi_2); // TODO: Check Pi, and the order.
	}

	// To change ^2 to *foo

	// ([-*(+])(\w)\^2   -> \1\2*\2

	/*

	(%i42) x:(z-c)*e/g + a;
	(%o42) (e*(z-c))/g+a
	(%i43) y:(z-c)*f/g + b;
	(%o43) (f*(z-c))/g+b
	(%i44) X:(z-C)*E/G + A;
	(%o44) ((z-C)*E)/G+A
	(%i45) Y:(z-C)*F/G + B;
	(%o45) ((z-C)*F)/G+B
	(%i46) x^2 + y^2 - X^2 - Y^2;
	(%o46) -(((z-C)*F)/G+B)^2-(((z-C)*E)/G+A)^2+((f*(z-c))/g+b)^2+((e*(z-c))/g+a)^2
	(%i47) solve([%], [z]);
	
	[z=-(g*G*sqrt(((f^2+e^2)*B^2+(f^2+e^2)*A^2-a^2*f^2+2*a*b*e*f-b^2*e^2)*G^2+(((-2*f^2-2*e^2)*B*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*B)*F+((-2*f^2-2*e^2)*A*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*A)*E)*G+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*A^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*F^2+2*g^2*A*B*E*F+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*B^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*E^2)+((b*f+a*e)*g-c*f^2-c*e^2)*G^2+(-g^2*B*F-g^2*A*E)*G+g^2*C*F^2+g^2*C*E^2)/((f^2+e^2)*G^2-g^2*F^2-g^2*E^2),z=(g*G*sqrt(((f^2+e^2)*B^2+(f^2+e^2)*A^2-a^2*f^2+2*a*b*e*f-b^2*e^2)*G^2+(((-2*f^2-2*e^2)*B*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*B)*F+((-2*f^2-2*e^2)*A*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*A)*E)*G+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*A^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*F^2+2*g^2*A*B*E*F+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*B^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*E^2)+((-b*f-a*e)*g+c*f^2+c*e^2)*G^2+(g^2*B*F+g^2*A*E)*G-g^2*C*F^2-g^2*C*E^2)/((f^2+e^2)*G^2-g^2*F^2-g^2*E^2)]


	func(a,b,c,e,f,g,z):=((f*(z-c))/g+b)^2+((e*(z-c))/g+a)^2;
	plot2d([func(1, 1, 10, -1, -1, 0.5, x)], [x,9,12])$;
	*/

	double z1 = -(g*G*sqrt(((f*f+e*e)*B*B+(f*f+e*e)*A*A-a*a*f*f+2.0*a*b*e*f-b*b*e*e)*G*G+(((-2.0*f*f-2.0*e*e)*B*C+((-2.0*b*f-2.0*a*e)*g+2.0*c*f*f+2.0*c*e*e)*B)*F+((-2.0*f*f-2.0*e*e)*A*C+((-2.0*b*f-2.0*a*e)*g+2.0*c*f*f+2.0*c*e*e)*A)*E)*G+((f*f+e*e)*C*C+((2.0*b*f+2.0*a*e)*g-2.0*c*f*f-2.0*c*e*e)*C-g*g*A*A+(b*b+a*a)*g*g+(-2.0*b*c*f-2.0*a*c*e)*g+c*c*f*f+c*c*e*e)*F*F+2.0*g*g*A*B*E*F+((f*f+e*e)*C*C+((2.0*b*f+2.0*a*e)*g-2.0*c*f*f-2.0*c*e*e)*C-g*g*B*B+(b*b+a*a)*g*g+(-2.0*b*c*f-2.0*a*c*e)*g+c*c*f*f+c*c*e*e)*E*E)+((b*f+a*e)*g-c*f*f-c*e*e)*G*G+(-g*g*B*F-g*g*A*E)*G+g*g*C*F*F+g*g*C*E*E)/((f*f+e*e)*G*G-g*g*F*F-g*g*E*E);

	double z2 = (g*G*sqrt(((f*f+e*e)*B*B+(f*f+e*e)*A*A-a*a*f*f+2*a*b*e*f-b*b*e*e)*G*G+(((-2*f*f-2*e*e)*B*C+((-2*b*f-2*a*e)*g+2*c*f*f+2*c*e*e)*B)*F+((-2*f*f-2*e*e)*A*C+((-2*b*f-2*a*e)*g+2*c*f*f+2*c*e*e)*A)*E)*G+((f*f+e*e)*C*C+((2*b*f+2*a*e)*g-2*c*f*f-2*c*e*e)*C-g*g*A*A+(b*b+a*a)*g*g+(-2*b*c*f-2*a*c*e)*g+c*c*f*f+c*c*e*e)*F*F+2*g*g*A*B*E*F+((f*f+e*e)*C*C+((2*b*f+2*a*e)*g-2*c*f*f-2*c*e*e)*C-g*g*B*B+(b*b+a*a)*g*g+(-2*b*c*f-2*a*c*e)*g+c*c*f*f+c*c*e*e)*E*E)+((-b*f-a*e)*g+c*f*f+c*e*e)*G*G+(g*g*B*F+g*g*A*E)*G-g*g*C*F*F-g*g*C*E*E)/((f*f+e*e)*G*G-g*g*F*F-g*g*E*E);

	// Now find the point x and y values on the fixed and rotating lines at the z value. We can then merely find the angle between them.

	// Z component is the same so it doesn't matter.
	Vector fixed_1((z1 - c) * e / g + a, (z1 - c) * f / g + b, 0.0); 
	Vector fixed_2((z2 - c) * e / g + a, (z2 - c) * f / g + b, 0.0);

	Vector rotating_1((z1 - C) * E / G + A, (z1 - C) * F / G + B, 0.0);
	Vector rotating_2((z2 - C) * E / G + A, (z2 - C) * F / G + B, 0.0);

	// Now merely find the angle between them.

	double a1 = angleFrom(fixed_1.X, fixed_1.Y, rotating_1.X, rotating_1.Y);
	double a2 = angleFrom(fixed_2.X, fixed_2.Y, rotating_2.X, rotating_2.Y);
	
	Vector rotated_point = Rotate(rotating_point_, Vector(), ZZ * a1);
	Vector rotated_direction = Rotate(rotating_direction_, Vector(), ZZ * a1);
	
	return pair<double, double>(a1, a2);

	//	return pair<double, double>(-asin((fixed_1.Normalised() ^ rotating_1.Normalised()).Z),
	//	                            -asin((fixed_2.Normalised() ^ rotating_2.Normalised()).Z));

	// TODO: Fix the probably numerous sign issues! Probably have to use ^ and asin() for the last bit.
}









vector<double> GetSVD(const Block1& block1, const Block3& block3)
{

	Vector planeOffset = block1.GetSymmetryHingeOffset();
	Vector planeNormal = (block1.GetSymmetryHingeDirection() ^ block3.GetSymmetryHingeDirection())
		+ ((block1.GetSymmetryHingeOffset() - block3.GetSymmetryHingeOffset()) ^ block1.GetSymmetryHingeDirection());
	planeNormal.Normalise();
	
	Block1 block4 = block1.Reflected(planeOffset, planeNormal);
	Block3 block6 = block3.Reflected(planeOffset, planeNormal);
		
	// Now we pretty much have all the hinge positions - just need to:
	// Construct matrix.
	// Do SVD.
	// Return second SV.
	
	// Hinge positions.
	Vector r1 = block3.GetFoldingHingeOffset();
	Vector r2 = block3.GetSymmetryHingeOffset();
	Vector r3 = block6.GetFoldingHingeOffset();
	Vector r4 = block4.GetFoldingHingeOffset();
	Vector r5 = block1.GetSymmetryHingeOffset();
	Vector r6 = block1.GetFoldingHingeOffset();
	
	// Hinge directions.
	Vector h1 = block3.GetFoldingHingeDirection().Normalised();
	Vector h2 = block3.GetSymmetryHingeDirection().Normalised();
	Vector h3 = block6.GetFoldingHingeDirection().Normalised();
	Vector h4 = block4.GetFoldingHingeDirection().Normalised();
	Vector h5 = block1.GetSymmetryHingeDirection().Normalised();
	Vector h6 = block1.GetFoldingHingeDirection().Normalised();
	

	vector<double> ret;
	ret.push_back(0.0);
	ret.push_back(0.0);
	ret.push_back(0.0);
	ret.push_back(0.0);
	ret.push_back(0.0);
	ret.push_back(0.0);
	// Construct THE MAAAATRIX!
	
	gsl_matrix* A = gsl_matrix_alloc(6, 6);
	if (!A)
		return ret;
	
	gsl_matrix* V = gsl_matrix_alloc(6, 6);
	if (!V)
		return ret;
	
	gsl_vector* S = gsl_vector_alloc(6);
	if (!S)
		return ret;
	
	gsl_vector* work = gsl_vector_alloc(6);
	if (!work)
		return ret;
	
	gsl_matrix_set(A, 0, 0, h1.X);
	gsl_matrix_set(A, 1, 0, h1.Y);
	gsl_matrix_set(A, 2, 0, h1.Z);
	gsl_matrix_set(A, 3, 0, (r1 ^ h1).X);
	gsl_matrix_set(A, 4, 0, (r1 ^ h1).Y);
	gsl_matrix_set(A, 5, 0, (r1 ^ h1).Z);
	
	gsl_matrix_set(A, 0, 1, h2.X);
	gsl_matrix_set(A, 1, 1, h2.Y);
	gsl_matrix_set(A, 2, 1, h2.Z);
	gsl_matrix_set(A, 3, 1, (r2 ^ h2).X);
	gsl_matrix_set(A, 4, 1, (r2 ^ h2).Y);
	gsl_matrix_set(A, 5, 1, (r2 ^ h2).Z);
	
	gsl_matrix_set(A, 0, 2, h3.X);
	gsl_matrix_set(A, 1, 2, h3.Y);
	gsl_matrix_set(A, 2, 2, h3.Z);
	gsl_matrix_set(A, 3, 2, (r3 ^ h3).X);
	gsl_matrix_set(A, 4, 2, (r3 ^ h3).Y);
	gsl_matrix_set(A, 5, 2, (r3 ^ h3).Z);
	
	gsl_matrix_set(A, 0, 3, h4.X);
	gsl_matrix_set(A, 1, 3, h4.Y);
	gsl_matrix_set(A, 2, 3, h4.Z);
	gsl_matrix_set(A, 3, 3, (r4 ^ h4).X);
	gsl_matrix_set(A, 4, 3, (r4 ^ h4).Y);
	gsl_matrix_set(A, 5, 3, (r4 ^ h4).Z);
	
	gsl_matrix_set(A, 0, 4, h5.X);
	gsl_matrix_set(A, 1, 4, h5.Y);
	gsl_matrix_set(A, 2, 4, h5.Z);
	gsl_matrix_set(A, 3, 4, (r5 ^ h5).X);
	gsl_matrix_set(A, 4, 4, (r5 ^ h5).Y);
	gsl_matrix_set(A, 5, 4, (r5 ^ h5).Z);
	
	gsl_matrix_set(A, 0, 5, h6.X);
	gsl_matrix_set(A, 1, 5, h6.Y);
	gsl_matrix_set(A, 2, 5, h6.Z);
	gsl_matrix_set(A, 3, 5, (r6 ^ h6).X);
	gsl_matrix_set(A, 4, 5, (r6 ^ h6).Y);
	gsl_matrix_set(A, 5, 5, (r6 ^ h6).Z);
	
	gsl_linalg_SV_decomp(A, V, S, work);
	
	ret.clear();
	ret.push_back(gsl_vector_get(S, 0));
	ret.push_back(gsl_vector_get(S, 1));
	ret.push_back(gsl_vector_get(S, 2));
	ret.push_back(gsl_vector_get(S, 3));
	ret.push_back(gsl_vector_get(S, 4));
	ret.push_back(gsl_vector_get(S, 5));
		
	gsl_matrix_free(A);	
	gsl_matrix_free(V);	
	gsl_vector_free(S);	
	gsl_vector_free(work);

	return ret;
}


