#include "Maths.h"

#include "Graphics.h"

#include <QDebug>

// Ok this is a bit silly.
pair<double, double> RotationsForPlaneHack(const Vector& fixed_point, const Vector& fixed_direction,
                                       const Vector& rotating_point, const Vector& rotating_direction,
                                           const Vector& axis);

pair<double, double> RotationsForPlane(Vector x, Vector a, Vector y, Vector b, Vector g, Vector h)
{
	a.Normalise();
	b.Normalise();
	h.Normalise();

	return RotationsForPlaneHack(x - g, a, y - g, b, h);
}







double angleOf(double x, double y)
{
	double len = sqrt(x*x + y*y);
	if (len == 0.0)
		return 0.0;
	x /= len;
	y /= len;
	if (y == 0.0)
	{
		if (x < 0.0)
			return Pi3_2;
		else
			return Pi_2;
	}
	else if (x == 0.0)
	{
		if (y < 0.0)
			return Pi;
		else
			return 0.0;
	}
	else
	{
		double r = atan(x/y);
		if (y < 0.0)
			r += Pi;
		return r;
	}
	return 0.0;
}

double angleFrom(double x1, double y1, double x2, double y2)
{
	double r = angleOf(x2, y2) - angleOf(x1, y1);
	while (r >= Pi2)
		r -= Pi2;
	while (r <= 0.0)
		r += Pi2;
	return r;
}

pair<double, double> RotationsForPlaneHack(const Vector& fixed_point, const Vector& fixed_direction,
                                       const Vector& rotating_point, const Vector& rotating_direction,
                                       const Vector& axis)
{
	// To make this simple, we will rotate the whole thing so that the axis is just the z axis.
	// Presumably the maths could be worked out but this is more simple.

	// Work out the axis that we must rotate everything about to get /axis/ as the z axis.

	Vector rotateAllAxis = axis.Normalised() ^ ZZ;

	// The angle.
	
	double angle = asin(rotateAllAxis * rotateAllAxis.Normalised());
	if (axis.Z < 0)
		angle = Pi - angle;
	
	rotateAllAxis = rotateAllAxis.Normalised() * angle;

	// Now rotate everything like that.

	Vector fixed_point_ = Rotate(fixed_point, Vector(), rotateAllAxis);
	Vector fixed_direction_ = Rotate(fixed_direction.Normalised(), Vector(), rotateAllAxis);
	Vector rotating_point_ = Rotate(rotating_point, Vector(), rotateAllAxis);
	Vector rotating_direction_ = Rotate(rotating_direction.Normalised(), Vector(), rotateAllAxis);

	// There, now axis is just ZZ.

	// Now we need to find the two points on both lines when x^2 + y^2 is the same. This is given by z1, z2 = :

	double a = fixed_point_.X;
	double b = fixed_point_.Y;
	double c = fixed_point_.Z;

	double e = fixed_direction_.X;
	double f = fixed_direction_.Y;
	double g = fixed_direction_.Z;
	
	double A = rotating_point_.X;
	double B = rotating_point_.Y;
	double C = rotating_point_.Z;

	double E = rotating_direction_.X;
	double F = rotating_direction_.Y;
	double G = rotating_direction_.Z;

	if (e == E && f == F && g == G)
	{
		qDebug() << "Same direction" << endl;
		return pair<double, double>(0.0, Pi_2); // TODO: Check Pi, and the order.
	}

	// To change ^2 to *foo

	// ([-*(+])(\w)\^2   -> \1\2*\2

	/*

	(%i42) x:(z-c)*e/g + a;
	(%o42) (e*(z-c))/g+a
	(%i43) y:(z-c)*f/g + b;
	(%o43) (f*(z-c))/g+b
	(%i44) X:(z-C)*E/G + A;
	(%o44) ((z-C)*E)/G+A
	(%i45) Y:(z-C)*F/G + B;
	(%o45) ((z-C)*F)/G+B
	(%i46) x^2 + y^2 - X^2 - Y^2;
	(%o46) -(((z-C)*F)/G+B)^2-(((z-C)*E)/G+A)^2+((f*(z-c))/g+b)^2+((e*(z-c))/g+a)^2
	(%i47) solve([%], [z]);
	
	[z=-(g*G*sqrt(((f^2+e^2)*B^2+(f^2+e^2)*A^2-a^2*f^2+2*a*b*e*f-b^2*e^2)*G^2+(((-2*f^2-2*e^2)*B*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*B)*F+((-2*f^2-2*e^2)*A*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*A)*E)*G+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*A^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*F^2+2*g^2*A*B*E*F+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*B^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*E^2)+((b*f+a*e)*g-c*f^2-c*e^2)*G^2+(-g^2*B*F-g^2*A*E)*G+g^2*C*F^2+g^2*C*E^2)/((f^2+e^2)*G^2-g^2*F^2-g^2*E^2),z=(g*G*sqrt(((f^2+e^2)*B^2+(f^2+e^2)*A^2-a^2*f^2+2*a*b*e*f-b^2*e^2)*G^2+(((-2*f^2-2*e^2)*B*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*B)*F+((-2*f^2-2*e^2)*A*C+((-2*b*f-2*a*e)*g+2*c*f^2+2*c*e^2)*A)*E)*G+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*A^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*F^2+2*g^2*A*B*E*F+((f^2+e^2)*C^2+((2*b*f+2*a*e)*g-2*c*f^2-2*c*e^2)*C-g^2*B^2+(b^2+a^2)*g^2+(-2*b*c*f-2*a*c*e)*g+c^2*f^2+c^2*e^2)*E^2)+((-b*f-a*e)*g+c*f^2+c*e^2)*G^2+(g^2*B*F+g^2*A*E)*G-g^2*C*F^2-g^2*C*E^2)/((f^2+e^2)*G^2-g^2*F^2-g^2*E^2)]


	func(a,b,c,e,f,g,z):=((f*(z-c))/g+b)^2+((e*(z-c))/g+a)^2;
	plot2d([func(1, 1, 10, -1, -1, 0.5, x)], [x,9,12])$;
	*/

	double z1 = -(g*G*sqrt(((f*f+e*e)*B*B+(f*f+e*e)*A*A-a*a*f*f+2.0*a*b*e*f-b*b*e*e)*G*G+(((-2.0*f*f-2.0*e*e)*B*C+((-2.0*b*f-2.0*a*e)*g+2.0*c*f*f+2.0*c*e*e)*B)*F+((-2.0*f*f-2.0*e*e)*A*C+((-2.0*b*f-2.0*a*e)*g+2.0*c*f*f+2.0*c*e*e)*A)*E)*G+((f*f+e*e)*C*C+((2.0*b*f+2.0*a*e)*g-2.0*c*f*f-2.0*c*e*e)*C-g*g*A*A+(b*b+a*a)*g*g+(-2.0*b*c*f-2.0*a*c*e)*g+c*c*f*f+c*c*e*e)*F*F+2.0*g*g*A*B*E*F+((f*f+e*e)*C*C+((2.0*b*f+2.0*a*e)*g-2.0*c*f*f-2.0*c*e*e)*C-g*g*B*B+(b*b+a*a)*g*g+(-2.0*b*c*f-2.0*a*c*e)*g+c*c*f*f+c*c*e*e)*E*E)+((b*f+a*e)*g-c*f*f-c*e*e)*G*G+(-g*g*B*F-g*g*A*E)*G+g*g*C*F*F+g*g*C*E*E)/((f*f+e*e)*G*G-g*g*F*F-g*g*E*E);

	double z2 = (g*G*sqrt(((f*f+e*e)*B*B+(f*f+e*e)*A*A-a*a*f*f+2*a*b*e*f-b*b*e*e)*G*G+(((-2*f*f-2*e*e)*B*C+((-2*b*f-2*a*e)*g+2*c*f*f+2*c*e*e)*B)*F+((-2*f*f-2*e*e)*A*C+((-2*b*f-2*a*e)*g+2*c*f*f+2*c*e*e)*A)*E)*G+((f*f+e*e)*C*C+((2*b*f+2*a*e)*g-2*c*f*f-2*c*e*e)*C-g*g*A*A+(b*b+a*a)*g*g+(-2*b*c*f-2*a*c*e)*g+c*c*f*f+c*c*e*e)*F*F+2*g*g*A*B*E*F+((f*f+e*e)*C*C+((2*b*f+2*a*e)*g-2*c*f*f-2*c*e*e)*C-g*g*B*B+(b*b+a*a)*g*g+(-2*b*c*f-2*a*c*e)*g+c*c*f*f+c*c*e*e)*E*E)+((-b*f-a*e)*g+c*f*f+c*e*e)*G*G+(g*g*B*F+g*g*A*E)*G-g*g*C*F*F-g*g*C*E*E)/((f*f+e*e)*G*G-g*g*F*F-g*g*E*E);

	qDebug() << "Z1, Z2: " << z1 << z2;

	// Now find the point x and y values on the fixed and rotating lines at the z value. We can then merely find the angle between them.

	// Z component is the same so it doesn't matter.
	Vector fixed_1((z1 - c) * e / g + a, (z1 - c) * f / g + b, 0.0); 
	Vector fixed_2((z2 - c) * e / g + a, (z2 - c) * f / g + b, 0.0);

	Vector rotating_1((z1 - C) * E / G + A, (z1 - C) * F / G + B, 0.0);
	Vector rotating_2((z2 - C) * E / G + A, (z2 - C) * F / G + B, 0.0);

	// Now merely find the angle between them.

	double a1 = angleFrom(fixed_1.X, fixed_1.Y, rotating_1.X, rotating_1.Y);
	double a2 = angleFrom(fixed_2.X, fixed_2.Y, rotating_2.X, rotating_2.Y);
	
	Vector rotated_point = Rotate(rotating_point_, Vector(), ZZ * a1);
	Vector rotated_direction = Rotate(rotating_direction_, Vector(), ZZ * a1);
	

	//	if (render)
	if (false)
	{
		glPushMatrix();
		glRotated(-rotateAllAxis.Magnitude() * 360.0 / Pi2, rotateAllAxis.Normalised().X, rotateAllAxis.Normalised().Y, rotateAllAxis.Normalised().Z);
		glLineWidth(3.0f);
		glPushAttrib(GL_CURRENT_BIT);
		glPushAttrib(GL_ENABLE_BIT);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_LIGHTING);
		glBegin(GL_LINES);
		
		glColor4d(0.0, 0.0, 1.0, 1.0);
		glVertex(Vector());
		glVertex(rotateAllAxis);
		glColor4d(0.0, 0.0, 1.0, 1.0);
		glVertex(Vector());
		glVertex(ZZ * 5.0);
		
		glColor4d(1.0, 1.0, 0.0, 1.0);
		glVertex(Vector());
		glVertex(fixed_point_);
		glColor4d(1.0, 0.0, 0.0, 1.0);
		glVertex(fixed_point_ - fixed_direction_ * 10.0);
		glVertex(fixed_point_ + fixed_direction_ * 10.0);
		
		glColor4d(1.0, 0.0, 0.5, 1.0);
		glVertex(Vector());
		glVertex(rotating_point_);
		glColor4d(1.0, 0.0, 0.5, 1.0);
		glVertex(rotating_point_ - rotating_direction_ * 10.0);
		glVertex(rotating_point_ + rotating_direction_ * 10.0);

		glColor4d(0.0, 0.0, 0.0, 1.0);
		glVertex(z1 * ZZ);
		glVertex(fixed_1 + z1 * ZZ);
		glVertex(z1 * ZZ);
		glVertex(rotating_1 + z1 * ZZ);

		glColor4d(0.0, 1.0, 0.0, 1.0);
		glVertex(Vector());
		glVertex(rotated_point);
		glVertex(rotated_point - 5.0 * rotated_direction);
		glVertex(rotated_point + 5.0 * rotated_direction);
		
		glVertex(z1 * ZZ);
		glVertex(z1 * ZZ + (fixed_1.Normalised() ^ rotating_1.Normalised()));
		
		glEnd();
		glPopAttrib();
		glPopAttrib();
		glLineWidth(1.0f);
		glPopMatrix();
	}

	qDebug()  << " Angle: " << angleFrom(fixed_1.X, fixed_1.Y, rotating_1.X, rotating_1.Y);
	return pair<double, double>(a1, a2);
}
